<?php


class VideoProduct extends AppModel
{
    public $useTable = 'video_product';

    public $belongsTo = array(
        'Video' => array(
            'className' => 'Video',
            'foreignKey' => 'video_id',

        ),

        'Product' => array(
            'className' => 'Product',
            'foreignKey' => 'product_id',

        ),

       

    );



    public $custom_fields = array(
        "Video.id",
        "Video.user_id",
        "Video.description",
        "Video.video",
        "Video.thum",
        "Video.thum_small",
        "Video.gif",
        "Video.view",
        "Video.sound_id",
        "Video.privacy_type",
        "Video.allow_comments",
        "Video.allow_duet",
        "Video.duration",
        "Video.promote",
        "Video.pin_comment_id",
        "Video.pin",
        "Video.location_string",
        "Video.location_id",
        "Video.lat",
        "Video.long",
        "Video.width",
        "Video.height",
       
        "Video.user_thumbnail",
        "Video.default_thumbnail",
     
        "VideoProduct.*",


    );


    public function getDetails($id)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array('VideoProduct.id' => $id),
            //'recursive'=>-1

        ));

    }

    public function getAllCron()
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(
            'conditions' => array(
                'VideoProduct.updated_at <' => date('Y-m-d')
            ),
            //'limit' => 50,
            'order' => 'VideoProduct.id DESC',
        ));

    }

    public function ifExist($data)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(



                'VideoProduct.video_id'=> $data['video_id'],
                'VideoProduct.product_id'=> $data['product_id'],





            ),
           
        ));
    }

    public function getDetailsAgainstVideo($video_id)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(



                'VideoProduct.video_id'=> $video_id,






            ),
            'contain' => array('User'),
        ));
    }

    public function getOnlyDetailsAgainstVideo($video_id)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(



                'VideoProduct.video_id'=> $video_id,






            ),
            'recursive'=>-1
          
        ));
    }




    

   

   
    public function getDetailsWithUser($id)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array('Product.id' => $id),
            'contain' => array('User'),

            //'contain' => array(' Category','ProductImage'),
        ));

    }



    public function getAll()
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all',array(

         
            
            //'order' => array('Product.id DESC'),
        ));

    }





    public function deleteDataAgainstVideo($video_id){

        $this->deleteAll(
            [
                'VideoProduct.video_id' => $video_id,

            ],
            false # <- single delete statement please
        );
    }













}

?>